﻿//constructor for the box
function Box() {
    //private data members
    //x posn
    var x = 0,
    //y posn
    y = 0,
    //colour
    colour = "red",
    //size
    size = 20,
    //x velocity
    vx = 3.5,
    //y velocity
    vy = 3;

    //public property for VX
    Object.defineProperty(this, 'VX',
    {
        get: function () {
            return vx;
        },
        set: function (value) {
            vx = value;
        }
    }
    )

    //public property for VY
    Object.defineProperty(this, 'VY',
    {
        get: function () {
            return vy;
        },
        set: function (value) {
            vy = value;
        }
    }
    )

    //public property for size
    Object.defineProperty(this, 'Size',
    {
        get: function () {
            return size;
        },
        set: function (value) {
            size = value;
        }
    }
    )

    //public property for X
    Object.defineProperty(this, 'X',
    {
        get: function () {
            return x;
        },
        set: function (value) {
            x = value;
        }
    }
    )

    //public property for Y
    Object.defineProperty(this, 'Y',
    {
        get: function () {
            return y;
        },
        set: function (value) {
            y = value;
        }
    }
    )

    //function public draw method
    Box.prototype.draw = function (context) {
        //save the context
        context.save();
        //set x and y
        context.translate(x, y);
        //set the line width
        context.lineWidth = 2;
        //set the colour of the fill
        context.fillStyle = colour;
        //begin the path
        context.beginPath();
        //draw the box
        context.moveTo(-size, -size);
        context.lineTo(-size, size);
        context.lineTo(size, size);
        context.lineTo(size, -size);
        //close the path
        context.closePath();
        //fill the shape
        context.fill();
        //draw it
        context.stroke();
        //restore the context
        context.restore();
    };
}


